; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch64 -mattr=+lasx < %s | FileCheck %s

; TODO: Load a element and splat it to a vector could be lowerd to xvldrepl

; A load has more than one user shouldn't be lowered to xvldrepl
define <4 x i64> @should_not_be_optimized(ptr %ptr, ptr %dst) {
; CHECK-LABEL: should_not_be_optimized:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ld.d $a0, $a0, 0
; CHECK-NEXT:    xvreplgr2vr.d $xr0, $a0
; CHECK-NEXT:    st.d $a0, $a1, 0
; CHECK-NEXT:    ret
  %tmp = load i64, ptr %ptr
  store i64 %tmp, ptr %dst
  %tmp1 = insertelement <4 x i64> zeroinitializer, i64 %tmp, i32 0
  %tmp2 = shufflevector <4 x i64> %tmp1, <4 x i64> poison, <4 x i32> zeroinitializer
  ret <4 x i64> %tmp2
}

define <4 x i64> @xvldrepl_d_unaligned_offset(ptr %ptr) {
; CHECK-LABEL: xvldrepl_d_unaligned_offset:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $a0, $a0, 4
; CHECK-NEXT:    xvldrepl.d $xr0, $a0, 0
; CHECK-NEXT:    ret
  %p = getelementptr i32, ptr %ptr, i32 1
  %tmp = load i64, ptr %p
  %tmp1 = insertelement <4 x i64> zeroinitializer, i64 %tmp, i32 0
  %tmp2 = shufflevector <4 x i64> %tmp1, <4 x i64> poison, <4 x i32> zeroinitializer
  ret <4 x i64> %tmp2
}

define <32 x i8> @xvldrepl_b(ptr %ptr) {
; CHECK-LABEL: xvldrepl_b:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvldrepl.b $xr0, $a0, 0
; CHECK-NEXT:    ret
  %tmp = load i8, ptr %ptr
  %tmp1 = insertelement <32 x i8> zeroinitializer, i8 %tmp, i32 0
  %tmp2 = shufflevector <32 x i8> %tmp1, <32 x i8> poison, <32 x i32> zeroinitializer
  ret <32 x i8> %tmp2
}

define <32 x i8> @xvldrepl_b_offset(ptr %ptr) {
; CHECK-LABEL: xvldrepl_b_offset:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvldrepl.b $xr0, $a0, 33
; CHECK-NEXT:    ret
  %p = getelementptr i8, ptr %ptr, i64 33
  %tmp = load i8, ptr %p
  %tmp1 = insertelement <32 x i8> zeroinitializer, i8 %tmp, i32 0
  %tmp2 = shufflevector <32 x i8> %tmp1, <32 x i8> poison, <32 x i32> zeroinitializer
  ret <32 x i8> %tmp2
}


define <16 x i16> @xvldrepl_h(ptr %ptr) {
; CHECK-LABEL: xvldrepl_h:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvldrepl.h $xr0, $a0, 0
; CHECK-NEXT:    ret
  %tmp = load i16, ptr %ptr
  %tmp1 = insertelement <16 x i16> zeroinitializer, i16 %tmp, i32 0
  %tmp2 = shufflevector <16 x i16> %tmp1, <16 x i16> poison, <16 x i32> zeroinitializer
  ret <16 x i16> %tmp2
}

define <16 x i16> @xvldrepl_h_offset(ptr %ptr) {
; CHECK-LABEL: xvldrepl_h_offset:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvldrepl.h $xr0, $a0, 66
; CHECK-NEXT:    ret
  %p = getelementptr i16, ptr %ptr, i64 33
  %tmp = load i16, ptr %p
  %tmp1 = insertelement <16 x i16> zeroinitializer, i16 %tmp, i32 0
  %tmp2 = shufflevector <16 x i16> %tmp1, <16 x i16> poison, <16 x i32> zeroinitializer
  ret <16 x i16> %tmp2
}

define <8 x i32> @xvldrepl_w(ptr %ptr) {
; CHECK-LABEL: xvldrepl_w:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvldrepl.w $xr0, $a0, 0
; CHECK-NEXT:    ret
  %tmp = load i32, ptr %ptr
  %tmp1 = insertelement <8 x i32> zeroinitializer, i32 %tmp, i32 0
  %tmp2 = shufflevector <8 x i32> %tmp1, <8 x i32> poison, <8 x i32> zeroinitializer
  ret <8 x i32> %tmp2
}

define <8 x i32> @xvldrepl_w_offset(ptr %ptr) {
; CHECK-LABEL: xvldrepl_w_offset:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvldrepl.w $xr0, $a0, 132
; CHECK-NEXT:    ret
  %p = getelementptr i32, ptr %ptr, i64 33
  %tmp = load i32, ptr %p
  %tmp1 = insertelement <8 x i32> zeroinitializer, i32 %tmp, i32 0
  %tmp2 = shufflevector <8 x i32> %tmp1, <8 x i32> poison, <8 x i32> zeroinitializer
  ret <8 x i32> %tmp2
}


define <4 x i64> @xvldrepl_d(ptr %ptr) {
; CHECK-LABEL: xvldrepl_d:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvldrepl.d $xr0, $a0, 0
; CHECK-NEXT:    ret
  %tmp = load i64, ptr %ptr
  %tmp1 = insertelement <4 x i64> zeroinitializer, i64 %tmp, i32 0
  %tmp2 = shufflevector <4 x i64> %tmp1, <4 x i64> poison, <4 x i32> zeroinitializer
  ret <4 x i64> %tmp2
}

define <4 x i64> @xvldrepl_d_offset(ptr %ptr) {
; CHECK-LABEL: xvldrepl_d_offset:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvldrepl.d $xr0, $a0, 264
; CHECK-NEXT:    ret
  %p = getelementptr i64, ptr %ptr, i64 33
  %tmp = load i64, ptr %p
  %tmp1 = insertelement <4 x i64> zeroinitializer, i64 %tmp, i32 0
  %tmp2 = shufflevector <4 x i64> %tmp1, <4 x i64> poison, <4 x i32> zeroinitializer
  ret <4 x i64> %tmp2
}

define <8 x float> @vldrepl_w_flt(ptr %ptr) {
; CHECK-LABEL: vldrepl_w_flt:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvldrepl.w $xr0, $a0, 0
; CHECK-NEXT:    ret
  %tmp = load float, ptr %ptr
  %tmp1 = insertelement <8 x float> zeroinitializer, float %tmp, i32 0
  %tmp2 = shufflevector <8 x float> %tmp1, <8 x float> poison, <8 x i32> zeroinitializer
  ret <8 x float> %tmp2
}

define <8 x float> @vldrepl_w_flt_offset(ptr %ptr) {
; CHECK-LABEL: vldrepl_w_flt_offset:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvldrepl.w $xr0, $a0, 264
; CHECK-NEXT:    ret
  %p = getelementptr i64, ptr %ptr, i64 33
  %tmp = load float, ptr %p
  %tmp1 = insertelement <8 x float> zeroinitializer, float %tmp, i32 0
  %tmp2 = shufflevector <8 x float> %tmp1, <8 x float> poison, <8 x i32> zeroinitializer
  ret <8 x float> %tmp2
}

define <4 x double> @vldrepl_d_dbl(ptr %ptr) {
; CHECK-LABEL: vldrepl_d_dbl:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvldrepl.d $xr0, $a0, 0
; CHECK-NEXT:    ret
  %tmp = load double, ptr %ptr
  %tmp1 = insertelement <4 x double> zeroinitializer, double %tmp, i32 0
  %tmp2 = shufflevector <4 x double> %tmp1, <4 x double> poison, <4 x i32> zeroinitializer
  ret <4 x double> %tmp2
}

define <4 x double> @vldrepl_d_dbl_offset(ptr %ptr) {
; CHECK-LABEL: vldrepl_d_dbl_offset:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvldrepl.d $xr0, $a0, 264
; CHECK-NEXT:    ret
  %p = getelementptr i64, ptr %ptr, i64 33
  %tmp = load double, ptr %p
  %tmp1 = insertelement <4 x double> zeroinitializer, double %tmp, i32 0
  %tmp2 = shufflevector <4 x double> %tmp1, <4 x double> poison, <4 x i32> zeroinitializer
  ret <4 x double> %tmp2
}

