/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.javadoc;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.tasks.compile.CompilationSourceDirs;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.javadoc.internal.JavadocExecutableUtils;
import org.gradle.api.tasks.javadoc.internal.JavadocSpec;
import org.gradle.api.tasks.javadoc.internal.JavadocToolAdapter;
import org.gradle.external.javadoc.MinimalJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.internal.jvm.DefaultModularitySpec;
import org.gradle.internal.jvm.JavaModuleDetector;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavadocTool;
import org.gradle.jvm.toolchain.internal.JavaExecutableUtils;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.util.internal.GUtil;

@CacheableTask
public abstract class Javadoc
extends SourceTask {
    private File destinationDir;
    private boolean failOnError = true;
    private String title;
    private String maxMemory;
    private final StandardJavadocDocletOptions options = new StandardJavadocDocletOptions();
    private FileCollection classpath = this.getProject().files(new Object[0]);
    private final ModularitySpec modularity;
    private String executable;
    private final Property<JavadocTool> javadocTool;

    public Javadoc() {
        ObjectFactory objectFactory = this.getObjectFactory();
        this.modularity = (ModularitySpec)objectFactory.newInstance(DefaultModularitySpec.class, new Object[0]);
        JavaToolchainService javaToolchainService = this.getJavaToolchainService();
        Provider javadocToolConvention = this.getProviderFactory().provider(() -> JavadocExecutableUtils.getExecutableOverrideToolchainSpec(this, objectFactory)).flatMap(arg_0 -> ((JavaToolchainService)javaToolchainService).javadocToolFor(arg_0)).orElse(javaToolchainService.javadocToolFor(it -> {}));
        this.javadocTool = objectFactory.property(JavadocTool.class).convention(javadocToolConvention);
        this.javadocTool.finalizeValueOnRead();
    }

    @TaskAction
    protected void generate() {
        String maxMemory;
        File destinationDir = this.getDestinationDir();
        try {
            this.getDeleter().ensureEmptyDirectory(destinationDir);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        StandardJavadocDocletOptions options = new StandardJavadocDocletOptions((StandardJavadocDocletOptions)this.getOptions());
        if (options.getDestinationDirectory() == null) {
            options.destinationDirectory(destinationDir);
        }
        boolean isModule = this.isModule();
        JavaModuleDetector javaModuleDetector = this.getJavaModuleDetector();
        options.classpath(new ArrayList<File>(javaModuleDetector.inferClasspath(isModule, this.getClasspath()).getFiles()));
        options.modulePath(new ArrayList<File>(javaModuleDetector.inferModulePath(isModule, this.getClasspath()).getFiles()));
        if (options.getBootClasspath() != null && !options.getBootClasspath().isEmpty()) {
            this.getProjectLayout().files(new Object[]{options.getBootClasspath()}).getAsPath();
        }
        if (!GUtil.isTrue((Object)options.getWindowTitle()) && GUtil.isTrue((Object)this.getTitle())) {
            options.windowTitle(this.getTitle());
        }
        if (!GUtil.isTrue((Object)options.getDocTitle()) && GUtil.isTrue((Object)this.getTitle())) {
            options.setDocTitle(this.getTitle());
        }
        if ((maxMemory = this.getMaxMemory()) != null && options.getJFlags().stream().noneMatch(flag -> flag.startsWith("-Xmx"))) {
            options.jFlags("-Xmx" + maxMemory);
        }
        options.setSourceNames(this.sourceNames());
        JavadocSpec spec = this.createJavadocSpec(options);
        this.getJavadocToolAdapter().execute(spec);
    }

    private void validateExecutableMatchesToolchain() {
        File toolchainExecutable = ((JavadocTool)this.getJavadocTool().get()).getExecutablePath().getAsFile();
        String customExecutable = this.getExecutable();
        JavaExecutableUtils.validateExecutable((String)customExecutable, (String)"Toolchain from `executable` property", (File)toolchainExecutable, (String)"toolchain from `javadocTool` property");
    }

    private boolean isModule() {
        List<File> sourcesRoots = CompilationSourceDirs.inferSourceRoots((FileTreeInternal)this.getSource());
        return JavaModuleDetector.isModuleSource((boolean)((Boolean)this.modularity.getInferModulePath().get()), sourcesRoots);
    }

    private List<String> sourceNames() {
        ArrayList<String> sourceNames = new ArrayList<String>();
        for (File sourceFile : this.getSource()) {
            sourceNames.add(sourceFile.getAbsolutePath());
        }
        return sourceNames;
    }

    private JavadocSpec createJavadocSpec(StandardJavadocDocletOptions options) {
        this.validateExecutableMatchesToolchain();
        JavadocSpec spec = new JavadocSpec();
        spec.setOptions(options);
        spec.setIgnoreFailures(!this.isFailOnError());
        spec.setWorkingDir(this.getProjectLayout().getProjectDirectory().getAsFile());
        spec.setOptionsFile(this.getOptionsFile());
        JavadocToolAdapter javadocToolAdapter = this.getJavadocToolAdapter();
        spec.setExecutable(javadocToolAdapter.getExecutablePath().toString());
        return spec;
    }

    private JavadocToolAdapter getJavadocToolAdapter() {
        return (JavadocToolAdapter)this.getJavadocTool().get();
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @ToBeReplacedByLazyProperty
    public FileTree getSource() {
        return super.getSource();
    }

    @Nested
    public Property<JavadocTool> getJavadocTool() {
        return this.javadocTool;
    }

    @Internal
    @Nullable
    @ToBeReplacedByLazyProperty
    public File getDestinationDir() {
        return this.destinationDir;
    }

    @OutputDirectory
    protected File getOutputDirectory() {
        File destinationDir = this.getDestinationDir();
        if (destinationDir == null) {
            destinationDir = this.options.getDestinationDirectory();
        }
        return destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    @Internal
    @Nullable
    @ToBeReplacedByLazyProperty
    public String getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(String maxMemory) {
        this.maxMemory = maxMemory;
    }

    @Nullable
    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Deprecated
    @Internal
    public boolean isVerbose() {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(Javadoc.class, (String)"isVerbose()").replaceWith((Object)"getOptions().isVerbose()")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_javadoc_verbose")).nagUser();
        return this.options.isVerbose();
    }

    @Deprecated
    public void setVerbose(boolean verbose) {
        if (verbose) {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(Javadoc.class, (String)"setVerbose(true)").replaceWith((Object)"getOptions().verbose()")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_javadoc_verbose")).nagUser();
            this.options.verbose();
        } else {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(Javadoc.class, (String)"setVerbose(false)").withAdvice("Passing false to this method does nothing. You may want to call getOptions().quiet().")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_javadoc_verbose")).nagUser();
        }
    }

    @Classpath
    @ToBeReplacedByLazyProperty
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Nested
    public ModularitySpec getModularity() {
        return this.modularity;
    }

    @Nested
    public MinimalJavadocOptions getOptions() {
        return this.options;
    }

    public void options(@DelegatesTo(value=MinimalJavadocOptions.class) Closure<?> block) {
        ConfigureUtil.configure(block, (Object)this.getOptions());
    }

    public void options(Action<? super MinimalJavadocOptions> action) {
        action.execute((Object)this.getOptions());
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public File getOptionsFile() {
        return new File(this.getTemporaryDir(), "javadoc.options");
    }

    @Nullable
    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(@Nullable String executable) {
        this.executable = executable;
    }

    @Inject
    protected Deleter getDeleter() {
        throw new UnsupportedOperationException("Decorator takes care of injection");
    }

    @Inject
    protected ProjectLayout getProjectLayout() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaModuleDetector getJavaModuleDetector() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaToolchainService getJavaToolchainService() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ProviderFactory getProviderFactory() {
        throw new UnsupportedOperationException();
    }
}

