/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import java.util.List;
import java.util.Optional;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.ConfigurationSelectionException;
import org.gradle.internal.component.resolution.failure.type.ExternalRequestedConfigurationNotFoundFailure;

public abstract class ExternalRequestedConfigurationNotFoundFailureDescriber
extends AbstractResolutionFailureDescriber<ExternalRequestedConfigurationNotFoundFailure> {
    public ConfigurationSelectionException describeFailure(ExternalRequestedConfigurationNotFoundFailure failure, Optional<AttributesSchemaInternal> schema) {
        String message = this.buildExternalConfigurationNotFoundFailureMsg(failure);
        List<String> resolutions = this.buildResolutions(this.suggestReviewAlgorithm());
        return new ConfigurationSelectionException(message, failure, resolutions);
    }

    private String buildExternalConfigurationNotFoundFailureMsg(ExternalRequestedConfigurationNotFoundFailure failure) {
        return String.format("A dependency was declared from configuration '%s' to configuration '%s' which is not declared in the descriptor for %s.", failure.getFromConfigurationName(), failure.getRequestedName(), failure.getRequestedComponentDisplayName());
    }
}

