cmake_minimum_required(VERSION 3.19)
project(HelloQt LANGUAGES CXX)

find_package(Qt6 6.5 REQUIRED COMPONENTS Core Widgets)
find_package(Qt6 REQUIRED COMPONENTS Concurrent)

qt_standard_project_setup()

qt_add_executable(HelloQt
    WIN32 MACOSX_BUNDLE
    main.cpp
    mainwindow.cpp
    mainwindow.h
    mainwindow.ui
)

target_link_libraries(HelloQt
    PRIVATE
        Qt::Core
        Qt::Widgets
)
target_link_libraries(HelloQt PRIVATE Qt6::Concurrent)

include(GNUInstallDirs)

install(TARGETS HelloQt
    BUNDLE  DESTINATION .
    RUNTIME DESTINATION ${CMAKE_INSTALL_BINDIR}
    LIBRARY DESTINATION ${CMAKE_INSTALL_LIBDIR}
)

qt_generate_deploy_app_script(
    TARGET HelloQt
    OUTPUT_SCRIPT deploy_script
    NO_UNSUPPORTED_PLATFORM_ERROR
)
install(SCRIPT ${deploy_script})
