/* Copyright (c) 2002,2007-2009, Code Aurora Forum. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Code Aurora nor
 *       the names of its contributors may be used to endorse or promote
 *       products derived from this software without specific prior written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NON-INFRINGEMENT ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#if !defined (_yamato_TYPEDEF_HEADER)
#define _yamato_TYPEDEF_HEADER

#include "yamato_registers.h"

typedef union PA_CL_VPORT_XSCALE                regPA_CL_VPORT_XSCALE;
typedef union PA_CL_VPORT_XOFFSET               regPA_CL_VPORT_XOFFSET;
typedef union PA_CL_VPORT_YSCALE                regPA_CL_VPORT_YSCALE;
typedef union PA_CL_VPORT_YOFFSET               regPA_CL_VPORT_YOFFSET;
typedef union PA_CL_VPORT_ZSCALE                regPA_CL_VPORT_ZSCALE;
typedef union PA_CL_VPORT_ZOFFSET               regPA_CL_VPORT_ZOFFSET;
typedef union PA_CL_VTE_CNTL                    regPA_CL_VTE_CNTL;
typedef union PA_CL_CLIP_CNTL                   regPA_CL_CLIP_CNTL;
typedef union PA_CL_GB_VERT_CLIP_ADJ            regPA_CL_GB_VERT_CLIP_ADJ;
typedef union PA_CL_GB_VERT_DISC_ADJ            regPA_CL_GB_VERT_DISC_ADJ;
typedef union PA_CL_GB_HORZ_CLIP_ADJ            regPA_CL_GB_HORZ_CLIP_ADJ;
typedef union PA_CL_GB_HORZ_DISC_ADJ            regPA_CL_GB_HORZ_DISC_ADJ;
typedef union PA_CL_ENHANCE                     regPA_CL_ENHANCE;
typedef union PA_SC_ENHANCE                     regPA_SC_ENHANCE;
typedef union PA_SU_VTX_CNTL                    regPA_SU_VTX_CNTL;
typedef union PA_SU_POINT_SIZE                  regPA_SU_POINT_SIZE;
typedef union PA_SU_POINT_MINMAX                regPA_SU_POINT_MINMAX;
typedef union PA_SU_LINE_CNTL                   regPA_SU_LINE_CNTL;
typedef union PA_SU_FACE_DATA                   regPA_SU_FACE_DATA;
typedef union PA_SU_SC_MODE_CNTL                regPA_SU_SC_MODE_CNTL;
typedef union PA_SU_POLY_OFFSET_FRONT_SCALE     regPA_SU_POLY_OFFSET_FRONT_SCALE;
typedef union PA_SU_POLY_OFFSET_FRONT_OFFSET    regPA_SU_POLY_OFFSET_FRONT_OFFSET;
typedef union PA_SU_POLY_OFFSET_BACK_SCALE      regPA_SU_POLY_OFFSET_BACK_SCALE;
typedef union PA_SU_POLY_OFFSET_BACK_OFFSET     regPA_SU_POLY_OFFSET_BACK_OFFSET;
typedef union PA_SU_PERFCOUNTER0_SELECT         regPA_SU_PERFCOUNTER0_SELECT;
typedef union PA_SU_PERFCOUNTER1_SELECT         regPA_SU_PERFCOUNTER1_SELECT;
typedef union PA_SU_PERFCOUNTER2_SELECT         regPA_SU_PERFCOUNTER2_SELECT;
typedef union PA_SU_PERFCOUNTER3_SELECT         regPA_SU_PERFCOUNTER3_SELECT;
typedef union PA_SU_PERFCOUNTER0_LOW            regPA_SU_PERFCOUNTER0_LOW;
typedef union PA_SU_PERFCOUNTER0_HI             regPA_SU_PERFCOUNTER0_HI;
typedef union PA_SU_PERFCOUNTER1_LOW            regPA_SU_PERFCOUNTER1_LOW;
typedef union PA_SU_PERFCOUNTER1_HI             regPA_SU_PERFCOUNTER1_HI;
typedef union PA_SU_PERFCOUNTER2_LOW            regPA_SU_PERFCOUNTER2_LOW;
typedef union PA_SU_PERFCOUNTER2_HI             regPA_SU_PERFCOUNTER2_HI;
typedef union PA_SU_PERFCOUNTER3_LOW            regPA_SU_PERFCOUNTER3_LOW;
typedef union PA_SU_PERFCOUNTER3_HI             regPA_SU_PERFCOUNTER3_HI;
typedef union PA_SC_WINDOW_OFFSET               regPA_SC_WINDOW_OFFSET;
typedef union PA_SC_AA_CONFIG                   regPA_SC_AA_CONFIG;
typedef union PA_SC_AA_MASK                     regPA_SC_AA_MASK;
typedef union PA_SC_LINE_STIPPLE                regPA_SC_LINE_STIPPLE;
typedef union PA_SC_LINE_CNTL                   regPA_SC_LINE_CNTL;
typedef union PA_SC_WINDOW_SCISSOR_TL           regPA_SC_WINDOW_SCISSOR_TL;
typedef union PA_SC_WINDOW_SCISSOR_BR           regPA_SC_WINDOW_SCISSOR_BR;
typedef union PA_SC_SCREEN_SCISSOR_TL           regPA_SC_SCREEN_SCISSOR_TL;
typedef union PA_SC_SCREEN_SCISSOR_BR           regPA_SC_SCREEN_SCISSOR_BR;
typedef union PA_SC_VIZ_QUERY                   regPA_SC_VIZ_QUERY;
typedef union PA_SC_VIZ_QUERY_STATUS            regPA_SC_VIZ_QUERY_STATUS;
typedef union PA_SC_LINE_STIPPLE_STATE          regPA_SC_LINE_STIPPLE_STATE;
typedef union PA_SC_PERFCOUNTER0_SELECT         regPA_SC_PERFCOUNTER0_SELECT;
typedef union PA_SC_PERFCOUNTER0_LOW            regPA_SC_PERFCOUNTER0_LOW;
typedef union PA_SC_PERFCOUNTER0_HI             regPA_SC_PERFCOUNTER0_HI;
typedef union PA_CL_CNTL_STATUS                 regPA_CL_CNTL_STATUS;
typedef union PA_SU_CNTL_STATUS                 regPA_SU_CNTL_STATUS;
typedef union PA_SC_CNTL_STATUS                 regPA_SC_CNTL_STATUS;
typedef union PA_SU_DEBUG_CNTL                  regPA_SU_DEBUG_CNTL;
typedef union PA_SU_DEBUG_DATA                  regPA_SU_DEBUG_DATA;
typedef union PA_SC_DEBUG_CNTL                  regPA_SC_DEBUG_CNTL;
typedef union PA_SC_DEBUG_DATA                  regPA_SC_DEBUG_DATA;
typedef union GFX_COPY_STATE                    regGFX_COPY_STATE;
typedef union VGT_DRAW_INITIATOR                regVGT_DRAW_INITIATOR;
typedef union VGT_EVENT_INITIATOR               regVGT_EVENT_INITIATOR;
typedef union VGT_DMA_BASE                      regVGT_DMA_BASE;
typedef union VGT_DMA_SIZE                      regVGT_DMA_SIZE;
typedef union VGT_BIN_BASE                      regVGT_BIN_BASE;
typedef union VGT_BIN_SIZE                      regVGT_BIN_SIZE;
typedef union VGT_CURRENT_BIN_ID_MIN            regVGT_CURRENT_BIN_ID_MIN;
typedef union VGT_CURRENT_BIN_ID_MAX            regVGT_CURRENT_BIN_ID_MAX;
typedef union VGT_IMMED_DATA                    regVGT_IMMED_DATA;
typedef union VGT_MAX_VTX_INDX                  regVGT_MAX_VTX_INDX;
typedef union VGT_MIN_VTX_INDX                  regVGT_MIN_VTX_INDX;
typedef union VGT_INDX_OFFSET                   regVGT_INDX_OFFSET;
typedef union VGT_VERTEX_REUSE_BLOCK_CNTL       regVGT_VERTEX_REUSE_BLOCK_CNTL;
typedef union VGT_OUT_DEALLOC_CNTL              regVGT_OUT_DEALLOC_CNTL;
typedef union VGT_MULTI_PRIM_IB_RESET_INDX      regVGT_MULTI_PRIM_IB_RESET_INDX;
typedef union VGT_ENHANCE                       regVGT_ENHANCE;
typedef union VGT_VTX_VECT_EJECT_REG            regVGT_VTX_VECT_EJECT_REG;
typedef union VGT_LAST_COPY_STATE               regVGT_LAST_COPY_STATE;
typedef union VGT_DEBUG_CNTL                    regVGT_DEBUG_CNTL;
typedef union VGT_DEBUG_DATA                    regVGT_DEBUG_DATA;
typedef union VGT_CNTL_STATUS                   regVGT_CNTL_STATUS;
typedef union VGT_CRC_SQ_DATA                   regVGT_CRC_SQ_DATA;
typedef union VGT_CRC_SQ_CTRL                   regVGT_CRC_SQ_CTRL;
typedef union VGT_PERFCOUNTER0_SELECT           regVGT_PERFCOUNTER0_SELECT;
typedef union VGT_PERFCOUNTER1_SELECT           regVGT_PERFCOUNTER1_SELECT;
typedef union VGT_PERFCOUNTER2_SELECT           regVGT_PERFCOUNTER2_SELECT;
typedef union VGT_PERFCOUNTER3_SELECT           regVGT_PERFCOUNTER3_SELECT;
typedef union VGT_PERFCOUNTER0_LOW              regVGT_PERFCOUNTER0_LOW;
typedef union VGT_PERFCOUNTER1_LOW              regVGT_PERFCOUNTER1_LOW;
typedef union VGT_PERFCOUNTER2_LOW              regVGT_PERFCOUNTER2_LOW;
typedef union VGT_PERFCOUNTER3_LOW              regVGT_PERFCOUNTER3_LOW;
typedef union VGT_PERFCOUNTER0_HI               regVGT_PERFCOUNTER0_HI;
typedef union VGT_PERFCOUNTER1_HI               regVGT_PERFCOUNTER1_HI;
typedef union VGT_PERFCOUNTER2_HI               regVGT_PERFCOUNTER2_HI;
typedef union VGT_PERFCOUNTER3_HI               regVGT_PERFCOUNTER3_HI;
typedef union TC_CNTL_STATUS                    regTC_CNTL_STATUS;
typedef union TCR_CHICKEN                       regTCR_CHICKEN;
typedef union TCF_CHICKEN                       regTCF_CHICKEN;
typedef union TCM_CHICKEN                       regTCM_CHICKEN;
typedef union TCR_PERFCOUNTER0_SELECT           regTCR_PERFCOUNTER0_SELECT;
typedef union TCR_PERFCOUNTER1_SELECT           regTCR_PERFCOUNTER1_SELECT;
typedef union TCR_PERFCOUNTER0_HI               regTCR_PERFCOUNTER0_HI;
typedef union TCR_PERFCOUNTER1_HI               regTCR_PERFCOUNTER1_HI;
typedef union TCR_PERFCOUNTER0_LOW              regTCR_PERFCOUNTER0_LOW;
typedef union TCR_PERFCOUNTER1_LOW              regTCR_PERFCOUNTER1_LOW;
typedef union TP_TC_CLKGATE_CNTL                regTP_TC_CLKGATE_CNTL;
typedef union TPC_CNTL_STATUS                   regTPC_CNTL_STATUS;
typedef union TPC_DEBUG0                        regTPC_DEBUG0;
typedef union TPC_DEBUG1                        regTPC_DEBUG1;
typedef union TPC_CHICKEN                       regTPC_CHICKEN;
typedef union TP0_CNTL_STATUS                   regTP0_CNTL_STATUS;
typedef union TP0_DEBUG                         regTP0_DEBUG;
typedef union TP0_CHICKEN                       regTP0_CHICKEN;
typedef union TP0_PERFCOUNTER0_SELECT           regTP0_PERFCOUNTER0_SELECT;
typedef union TP0_PERFCOUNTER0_HI               regTP0_PERFCOUNTER0_HI;
typedef union TP0_PERFCOUNTER0_LOW              regTP0_PERFCOUNTER0_LOW;
typedef union TP0_PERFCOUNTER1_SELECT           regTP0_PERFCOUNTER1_SELECT;
typedef union TP0_PERFCOUNTER1_HI               regTP0_PERFCOUNTER1_HI;
typedef union TP0_PERFCOUNTER1_LOW              regTP0_PERFCOUNTER1_LOW;
typedef union TCM_PERFCOUNTER0_SELECT           regTCM_PERFCOUNTER0_SELECT;
typedef union TCM_PERFCOUNTER1_SELECT           regTCM_PERFCOUNTER1_SELECT;
typedef union TCM_PERFCOUNTER0_HI               regTCM_PERFCOUNTER0_HI;
typedef union TCM_PERFCOUNTER1_HI               regTCM_PERFCOUNTER1_HI;
typedef union TCM_PERFCOUNTER0_LOW              regTCM_PERFCOUNTER0_LOW;
typedef union TCM_PERFCOUNTER1_LOW              regTCM_PERFCOUNTER1_LOW;
typedef union TCF_PERFCOUNTER0_SELECT           regTCF_PERFCOUNTER0_SELECT;
typedef union TCF_PERFCOUNTER1_SELECT           regTCF_PERFCOUNTER1_SELECT;
typedef union TCF_PERFCOUNTER2_SELECT           regTCF_PERFCOUNTER2_SELECT;
typedef union TCF_PERFCOUNTER3_SELECT           regTCF_PERFCOUNTER3_SELECT;
typedef union TCF_PERFCOUNTER4_SELECT           regTCF_PERFCOUNTER4_SELECT;
typedef union TCF_PERFCOUNTER5_SELECT           regTCF_PERFCOUNTER5_SELECT;
typedef union TCF_PERFCOUNTER6_SELECT           regTCF_PERFCOUNTER6_SELECT;
typedef union TCF_PERFCOUNTER7_SELECT           regTCF_PERFCOUNTER7_SELECT;
typedef union TCF_PERFCOUNTER8_SELECT           regTCF_PERFCOUNTER8_SELECT;
typedef union TCF_PERFCOUNTER9_SELECT           regTCF_PERFCOUNTER9_SELECT;
typedef union TCF_PERFCOUNTER10_SELECT          regTCF_PERFCOUNTER10_SELECT;
typedef union TCF_PERFCOUNTER11_SELECT          regTCF_PERFCOUNTER11_SELECT;
typedef union TCF_PERFCOUNTER0_HI               regTCF_PERFCOUNTER0_HI;
typedef union TCF_PERFCOUNTER1_HI               regTCF_PERFCOUNTER1_HI;
typedef union TCF_PERFCOUNTER2_HI               regTCF_PERFCOUNTER2_HI;
typedef union TCF_PERFCOUNTER3_HI               regTCF_PERFCOUNTER3_HI;
typedef union TCF_PERFCOUNTER4_HI               regTCF_PERFCOUNTER4_HI;
typedef union TCF_PERFCOUNTER5_HI               regTCF_PERFCOUNTER5_HI;
typedef union TCF_PERFCOUNTER6_HI               regTCF_PERFCOUNTER6_HI;
typedef union TCF_PERFCOUNTER7_HI               regTCF_PERFCOUNTER7_HI;
typedef union TCF_PERFCOUNTER8_HI               regTCF_PERFCOUNTER8_HI;
typedef union TCF_PERFCOUNTER9_HI               regTCF_PERFCOUNTER9_HI;
typedef union TCF_PERFCOUNTER10_HI              regTCF_PERFCOUNTER10_HI;
typedef union TCF_PERFCOUNTER11_HI              regTCF_PERFCOUNTER11_HI;
typedef union TCF_PERFCOUNTER0_LOW              regTCF_PERFCOUNTER0_LOW;
typedef union TCF_PERFCOUNTER1_LOW              regTCF_PERFCOUNTER1_LOW;
typedef union TCF_PERFCOUNTER2_LOW              regTCF_PERFCOUNTER2_LOW;
typedef union TCF_PERFCOUNTER3_LOW              regTCF_PERFCOUNTER3_LOW;
typedef union TCF_PERFCOUNTER4_LOW              regTCF_PERFCOUNTER4_LOW;
typedef union TCF_PERFCOUNTER5_LOW              regTCF_PERFCOUNTER5_LOW;
typedef union TCF_PERFCOUNTER6_LOW              regTCF_PERFCOUNTER6_LOW;
typedef union TCF_PERFCOUNTER7_LOW              regTCF_PERFCOUNTER7_LOW;
typedef union TCF_PERFCOUNTER8_LOW              regTCF_PERFCOUNTER8_LOW;
typedef union TCF_PERFCOUNTER9_LOW              regTCF_PERFCOUNTER9_LOW;
typedef union TCF_PERFCOUNTER10_LOW             regTCF_PERFCOUNTER10_LOW;
typedef union TCF_PERFCOUNTER11_LOW             regTCF_PERFCOUNTER11_LOW;
typedef union TCF_DEBUG                         regTCF_DEBUG;
typedef union TCA_FIFO_DEBUG                    regTCA_FIFO_DEBUG;
typedef union TCA_PROBE_DEBUG                   regTCA_PROBE_DEBUG;
typedef union TCA_TPC_DEBUG                     regTCA_TPC_DEBUG;
typedef union TCB_CORE_DEBUG                    regTCB_CORE_DEBUG;
typedef union TCB_TAG0_DEBUG                    regTCB_TAG0_DEBUG;
typedef union TCB_TAG1_DEBUG                    regTCB_TAG1_DEBUG;
typedef union TCB_TAG2_DEBUG                    regTCB_TAG2_DEBUG;
typedef union TCB_TAG3_DEBUG                    regTCB_TAG3_DEBUG;
typedef union TCB_FETCH_GEN_SECTOR_WALKER0_DEBUG regTCB_FETCH_GEN_SECTOR_WALKER0_DEBUG;
typedef union TCB_FETCH_GEN_WALKER_DEBUG        regTCB_FETCH_GEN_WALKER_DEBUG;
typedef union TCB_FETCH_GEN_PIPE0_DEBUG         regTCB_FETCH_GEN_PIPE0_DEBUG;
typedef union TCD_INPUT0_DEBUG                  regTCD_INPUT0_DEBUG;
typedef union TCD_DEGAMMA_DEBUG                 regTCD_DEGAMMA_DEBUG;
typedef union TCD_DXTMUX_SCTARB_DEBUG           regTCD_DXTMUX_SCTARB_DEBUG;
typedef union TCD_DXTC_ARB_DEBUG                regTCD_DXTC_ARB_DEBUG;
typedef union TCD_STALLS_DEBUG                  regTCD_STALLS_DEBUG;
typedef union TCO_STALLS_DEBUG                  regTCO_STALLS_DEBUG;
typedef union TCO_QUAD0_DEBUG0                  regTCO_QUAD0_DEBUG0;
typedef union TCO_QUAD0_DEBUG1                  regTCO_QUAD0_DEBUG1;
typedef union SQ_GPR_MANAGEMENT                 regSQ_GPR_MANAGEMENT;
typedef union SQ_FLOW_CONTROL                   regSQ_FLOW_CONTROL;
typedef union SQ_INST_STORE_MANAGMENT           regSQ_INST_STORE_MANAGMENT;
typedef union SQ_RESOURCE_MANAGMENT             regSQ_RESOURCE_MANAGMENT;
typedef union SQ_EO_RT                          regSQ_EO_RT;
typedef union SQ_DEBUG_MISC                     regSQ_DEBUG_MISC;
typedef union SQ_ACTIVITY_METER_CNTL            regSQ_ACTIVITY_METER_CNTL;
typedef union SQ_ACTIVITY_METER_STATUS          regSQ_ACTIVITY_METER_STATUS;
typedef union SQ_INPUT_ARB_PRIORITY             regSQ_INPUT_ARB_PRIORITY;
typedef union SQ_THREAD_ARB_PRIORITY            regSQ_THREAD_ARB_PRIORITY;
typedef union SQ_VS_WATCHDOG_TIMER              regSQ_VS_WATCHDOG_TIMER;
typedef union SQ_PS_WATCHDOG_TIMER              regSQ_PS_WATCHDOG_TIMER;
typedef union SQ_INT_CNTL                       regSQ_INT_CNTL;
typedef union SQ_INT_STATUS                     regSQ_INT_STATUS;
typedef union SQ_INT_ACK                        regSQ_INT_ACK;
typedef union SQ_DEBUG_INPUT_FSM                regSQ_DEBUG_INPUT_FSM;
typedef union SQ_DEBUG_CONST_MGR_FSM            regSQ_DEBUG_CONST_MGR_FSM;
typedef union SQ_DEBUG_TP_FSM                   regSQ_DEBUG_TP_FSM;
typedef union SQ_DEBUG_FSM_ALU_0                regSQ_DEBUG_FSM_ALU_0;
typedef union SQ_DEBUG_FSM_ALU_1                regSQ_DEBUG_FSM_ALU_1;
typedef union SQ_DEBUG_EXP_ALLOC                regSQ_DEBUG_EXP_ALLOC;
typedef union SQ_DEBUG_PTR_BUFF                 regSQ_DEBUG_PTR_BUFF;
typedef union SQ_DEBUG_GPR_VTX                  regSQ_DEBUG_GPR_VTX;
typedef union SQ_DEBUG_GPR_PIX                  regSQ_DEBUG_GPR_PIX;
typedef union SQ_DEBUG_TB_STATUS_SEL            regSQ_DEBUG_TB_STATUS_SEL;
typedef union SQ_DEBUG_VTX_TB_0                 regSQ_DEBUG_VTX_TB_0;
typedef union SQ_DEBUG_VTX_TB_1                 regSQ_DEBUG_VTX_TB_1;
typedef union SQ_DEBUG_VTX_TB_STATUS_REG        regSQ_DEBUG_VTX_TB_STATUS_REG;
typedef union SQ_DEBUG_VTX_TB_STATE_MEM         regSQ_DEBUG_VTX_TB_STATE_MEM;
typedef union SQ_DEBUG_PIX_TB_0                 regSQ_DEBUG_PIX_TB_0;
typedef union SQ_DEBUG_PIX_TB_STATUS_REG_0      regSQ_DEBUG_PIX_TB_STATUS_REG_0;
typedef union SQ_DEBUG_PIX_TB_STATUS_REG_1      regSQ_DEBUG_PIX_TB_STATUS_REG_1;
typedef union SQ_DEBUG_PIX_TB_STATUS_REG_2      regSQ_DEBUG_PIX_TB_STATUS_REG_2;
typedef union SQ_DEBUG_PIX_TB_STATUS_REG_3      regSQ_DEBUG_PIX_TB_STATUS_REG_3;
typedef union SQ_DEBUG_PIX_TB_STATE_MEM         regSQ_DEBUG_PIX_TB_STATE_MEM;
typedef union SQ_PERFCOUNTER0_SELECT            regSQ_PERFCOUNTER0_SELECT;
typedef union SQ_PERFCOUNTER1_SELECT            regSQ_PERFCOUNTER1_SELECT;
typedef union SQ_PERFCOUNTER2_SELECT            regSQ_PERFCOUNTER2_SELECT;
typedef union SQ_PERFCOUNTER3_SELECT            regSQ_PERFCOUNTER3_SELECT;
typedef union SQ_PERFCOUNTER0_LOW               regSQ_PERFCOUNTER0_LOW;
typedef union SQ_PERFCOUNTER0_HI                regSQ_PERFCOUNTER0_HI;
typedef union SQ_PERFCOUNTER1_LOW               regSQ_PERFCOUNTER1_LOW;
typedef union SQ_PERFCOUNTER1_HI                regSQ_PERFCOUNTER1_HI;
typedef union SQ_PERFCOUNTER2_LOW               regSQ_PERFCOUNTER2_LOW;
typedef union SQ_PERFCOUNTER2_HI                regSQ_PERFCOUNTER2_HI;
typedef union SQ_PERFCOUNTER3_LOW               regSQ_PERFCOUNTER3_LOW;
typedef union SQ_PERFCOUNTER3_HI                regSQ_PERFCOUNTER3_HI;
typedef union SX_PERFCOUNTER0_SELECT            regSX_PERFCOUNTER0_SELECT;
typedef union SX_PERFCOUNTER0_LOW               regSX_PERFCOUNTER0_LOW;
typedef union SX_PERFCOUNTER0_HI                regSX_PERFCOUNTER0_HI;
typedef union SQ_INSTRUCTION_ALU_0              regSQ_INSTRUCTION_ALU_0;
typedef union SQ_INSTRUCTION_ALU_1              regSQ_INSTRUCTION_ALU_1;
typedef union SQ_INSTRUCTION_ALU_2              regSQ_INSTRUCTION_ALU_2;
typedef union SQ_INSTRUCTION_CF_EXEC_0          regSQ_INSTRUCTION_CF_EXEC_0;
typedef union SQ_INSTRUCTION_CF_EXEC_1          regSQ_INSTRUCTION_CF_EXEC_1;
typedef union SQ_INSTRUCTION_CF_EXEC_2          regSQ_INSTRUCTION_CF_EXEC_2;
typedef union SQ_INSTRUCTION_CF_LOOP_0          regSQ_INSTRUCTION_CF_LOOP_0;
typedef union SQ_INSTRUCTION_CF_LOOP_1          regSQ_INSTRUCTION_CF_LOOP_1;
typedef union SQ_INSTRUCTION_CF_LOOP_2          regSQ_INSTRUCTION_CF_LOOP_2;
typedef union SQ_INSTRUCTION_CF_JMP_CALL_0      regSQ_INSTRUCTION_CF_JMP_CALL_0;
typedef union SQ_INSTRUCTION_CF_JMP_CALL_1      regSQ_INSTRUCTION_CF_JMP_CALL_1;
typedef union SQ_INSTRUCTION_CF_JMP_CALL_2      regSQ_INSTRUCTION_CF_JMP_CALL_2;
typedef union SQ_INSTRUCTION_CF_ALLOC_0         regSQ_INSTRUCTION_CF_ALLOC_0;
typedef union SQ_INSTRUCTION_CF_ALLOC_1         regSQ_INSTRUCTION_CF_ALLOC_1;
typedef union SQ_INSTRUCTION_CF_ALLOC_2         regSQ_INSTRUCTION_CF_ALLOC_2;
typedef union SQ_INSTRUCTION_TFETCH_0           regSQ_INSTRUCTION_TFETCH_0;
typedef union SQ_INSTRUCTION_TFETCH_1           regSQ_INSTRUCTION_TFETCH_1;
typedef union SQ_INSTRUCTION_TFETCH_2           regSQ_INSTRUCTION_TFETCH_2;
typedef union SQ_INSTRUCTION_VFETCH_0           regSQ_INSTRUCTION_VFETCH_0;
typedef union SQ_INSTRUCTION_VFETCH_1           regSQ_INSTRUCTION_VFETCH_1;
typedef union SQ_INSTRUCTION_VFETCH_2           regSQ_INSTRUCTION_VFETCH_2;
typedef union SQ_CONSTANT_0                     regSQ_CONSTANT_0;
typedef union SQ_CONSTANT_1                     regSQ_CONSTANT_1;
typedef union SQ_CONSTANT_2                     regSQ_CONSTANT_2;
typedef union SQ_CONSTANT_3                     regSQ_CONSTANT_3;
typedef union SQ_FETCH_0                        regSQ_FETCH_0;
typedef union SQ_FETCH_1                        regSQ_FETCH_1;
typedef union SQ_FETCH_2                        regSQ_FETCH_2;
typedef union SQ_FETCH_3                        regSQ_FETCH_3;
typedef union SQ_FETCH_4                        regSQ_FETCH_4;
typedef union SQ_FETCH_5                        regSQ_FETCH_5;
typedef union SQ_CONSTANT_VFETCH_0              regSQ_CONSTANT_VFETCH_0;
typedef union SQ_CONSTANT_VFETCH_1              regSQ_CONSTANT_VFETCH_1;
typedef union SQ_CONSTANT_T2                    regSQ_CONSTANT_T2;
typedef union SQ_CONSTANT_T3                    regSQ_CONSTANT_T3;
typedef union SQ_CF_BOOLEANS                    regSQ_CF_BOOLEANS;
typedef union SQ_CF_LOOP                        regSQ_CF_LOOP;
typedef union SQ_CONSTANT_RT_0                  regSQ_CONSTANT_RT_0;
typedef union SQ_CONSTANT_RT_1                  regSQ_CONSTANT_RT_1;
typedef union SQ_CONSTANT_RT_2                  regSQ_CONSTANT_RT_2;
typedef union SQ_CONSTANT_RT_3                  regSQ_CONSTANT_RT_3;
typedef union SQ_FETCH_RT_0                     regSQ_FETCH_RT_0;
typedef union SQ_FETCH_RT_1                     regSQ_FETCH_RT_1;
typedef union SQ_FETCH_RT_2                     regSQ_FETCH_RT_2;
typedef union SQ_FETCH_RT_3                     regSQ_FETCH_RT_3;
typedef union SQ_FETCH_RT_4                     regSQ_FETCH_RT_4;
typedef union SQ_FETCH_RT_5                     regSQ_FETCH_RT_5;
typedef union SQ_CF_RT_BOOLEANS                 regSQ_CF_RT_BOOLEANS;
typedef union SQ_CF_RT_LOOP                     regSQ_CF_RT_LOOP;
typedef union SQ_VS_PROGRAM                     regSQ_VS_PROGRAM;
typedef union SQ_PS_PROGRAM                     regSQ_PS_PROGRAM;
typedef union SQ_CF_PROGRAM_SIZE                regSQ_CF_PROGRAM_SIZE;
typedef union SQ_INTERPOLATOR_CNTL              regSQ_INTERPOLATOR_CNTL;
typedef union SQ_PROGRAM_CNTL                   regSQ_PROGRAM_CNTL;
typedef union SQ_WRAPPING_0                     regSQ_WRAPPING_0;
typedef union SQ_WRAPPING_1                     regSQ_WRAPPING_1;
typedef union SQ_VS_CONST                       regSQ_VS_CONST;
typedef union SQ_PS_CONST                       regSQ_PS_CONST;
typedef union SQ_CONTEXT_MISC                   regSQ_CONTEXT_MISC;
typedef union SQ_CF_RD_BASE                     regSQ_CF_RD_BASE;
typedef union SQ_DEBUG_MISC_0                   regSQ_DEBUG_MISC_0;
typedef union SQ_DEBUG_MISC_1                   regSQ_DEBUG_MISC_1;
typedef union MH_ARBITER_CONFIG                 regMH_ARBITER_CONFIG;
typedef union MH_CLNT_AXI_ID_REUSE              regMH_CLNT_AXI_ID_REUSE;
typedef union MH_INTERRUPT_MASK                 regMH_INTERRUPT_MASK;
typedef union MH_INTERRUPT_STATUS               regMH_INTERRUPT_STATUS;
typedef union MH_INTERRUPT_CLEAR                regMH_INTERRUPT_CLEAR;
typedef union MH_AXI_ERROR                      regMH_AXI_ERROR;
typedef union MH_PERFCOUNTER0_SELECT            regMH_PERFCOUNTER0_SELECT;
typedef union MH_PERFCOUNTER1_SELECT            regMH_PERFCOUNTER1_SELECT;
typedef union MH_PERFCOUNTER0_CONFIG            regMH_PERFCOUNTER0_CONFIG;
typedef union MH_PERFCOUNTER1_CONFIG            regMH_PERFCOUNTER1_CONFIG;
typedef union MH_PERFCOUNTER0_LOW               regMH_PERFCOUNTER0_LOW;
typedef union MH_PERFCOUNTER1_LOW               regMH_PERFCOUNTER1_LOW;
typedef union MH_PERFCOUNTER0_HI                regMH_PERFCOUNTER0_HI;
typedef union MH_PERFCOUNTER1_HI                regMH_PERFCOUNTER1_HI;
typedef union MH_DEBUG_CTRL                     regMH_DEBUG_CTRL;
typedef union MH_DEBUG_DATA                     regMH_DEBUG_DATA;
typedef union MH_AXI_HALT_CONTROL               regMH_AXI_HALT_CONTROL;
typedef union MH_MMU_CONFIG                     regMH_MMU_CONFIG;
typedef union MH_MMU_VA_RANGE                   regMH_MMU_VA_RANGE;
typedef union MH_MMU_PT_BASE                    regMH_MMU_PT_BASE;
typedef union MH_MMU_PAGE_FAULT                 regMH_MMU_PAGE_FAULT;
typedef union MH_MMU_TRAN_ERROR                 regMH_MMU_TRAN_ERROR;
typedef union MH_MMU_INVALIDATE                 regMH_MMU_INVALIDATE;
typedef union MH_MMU_MPU_BASE                   regMH_MMU_MPU_BASE;
typedef union MH_MMU_MPU_END                    regMH_MMU_MPU_END;
typedef union WAIT_UNTIL                        regWAIT_UNTIL;
typedef union RBBM_ISYNC_CNTL                   regRBBM_ISYNC_CNTL;
typedef union RBBM_STATUS                       regRBBM_STATUS;
typedef union RBBM_DSPLY                        regRBBM_DSPLY;
typedef union RBBM_RENDER_LATEST                regRBBM_RENDER_LATEST;
typedef union RBBM_RTL_RELEASE                  regRBBM_RTL_RELEASE;
typedef union RBBM_PATCH_RELEASE                regRBBM_PATCH_RELEASE;
typedef union RBBM_AUXILIARY_CONFIG             regRBBM_AUXILIARY_CONFIG;
typedef union RBBM_PERIPHID0                    regRBBM_PERIPHID0;
typedef union RBBM_PERIPHID1                    regRBBM_PERIPHID1;
typedef union RBBM_PERIPHID2                    regRBBM_PERIPHID2;
typedef union RBBM_PERIPHID3                    regRBBM_PERIPHID3;
typedef union RBBM_CNTL                         regRBBM_CNTL;
typedef union RBBM_SKEW_CNTL                    regRBBM_SKEW_CNTL;
typedef union RBBM_SOFT_RESET                   regRBBM_SOFT_RESET;
typedef union RBBM_PM_OVERRIDE1                 regRBBM_PM_OVERRIDE1;
typedef union RBBM_PM_OVERRIDE2                 regRBBM_PM_OVERRIDE2;
typedef union GC_SYS_IDLE                       regGC_SYS_IDLE;
typedef union NQWAIT_UNTIL                      regNQWAIT_UNTIL;
typedef union RBBM_DEBUG_OUT                    regRBBM_DEBUG_OUT;
typedef union RBBM_DEBUG_CNTL                   regRBBM_DEBUG_CNTL;
typedef union RBBM_DEBUG                        regRBBM_DEBUG;
typedef union RBBM_READ_ERROR                   regRBBM_READ_ERROR;
typedef union RBBM_WAIT_IDLE_CLOCKS             regRBBM_WAIT_IDLE_CLOCKS;
typedef union RBBM_INT_CNTL                     regRBBM_INT_CNTL;
typedef union RBBM_INT_STATUS                   regRBBM_INT_STATUS;
typedef union RBBM_INT_ACK                      regRBBM_INT_ACK;
typedef union MASTER_INT_SIGNAL                 regMASTER_INT_SIGNAL;
typedef union RBBM_PERFCOUNTER1_SELECT          regRBBM_PERFCOUNTER1_SELECT;
typedef union RBBM_PERFCOUNTER1_LO              regRBBM_PERFCOUNTER1_LO;
typedef union RBBM_PERFCOUNTER1_HI              regRBBM_PERFCOUNTER1_HI;
typedef union CP_RB_BASE                        regCP_RB_BASE;
typedef union CP_RB_CNTL                        regCP_RB_CNTL;
typedef union CP_RB_RPTR_ADDR                   regCP_RB_RPTR_ADDR;
typedef union CP_RB_RPTR                        regCP_RB_RPTR;
typedef union CP_RB_RPTR_WR                     regCP_RB_RPTR_WR;
typedef union CP_RB_WPTR                        regCP_RB_WPTR;
typedef union CP_RB_WPTR_DELAY                  regCP_RB_WPTR_DELAY;
typedef union CP_RB_WPTR_BASE                   regCP_RB_WPTR_BASE;
typedef union CP_IB1_BASE                       regCP_IB1_BASE;
typedef union CP_IB1_BUFSZ                      regCP_IB1_BUFSZ;
typedef union CP_IB2_BASE                       regCP_IB2_BASE;
typedef union CP_IB2_BUFSZ                      regCP_IB2_BUFSZ;
typedef union CP_ST_BASE                        regCP_ST_BASE;
typedef union CP_ST_BUFSZ                       regCP_ST_BUFSZ;
typedef union CP_QUEUE_THRESHOLDS               regCP_QUEUE_THRESHOLDS;
typedef union CP_MEQ_THRESHOLDS                 regCP_MEQ_THRESHOLDS;
typedef union CP_CSQ_AVAIL                      regCP_CSQ_AVAIL;
typedef union CP_STQ_AVAIL                      regCP_STQ_AVAIL;
typedef union CP_MEQ_AVAIL                      regCP_MEQ_AVAIL;
typedef union CP_CSQ_RB_STAT                    regCP_CSQ_RB_STAT;
typedef union CP_CSQ_IB1_STAT                   regCP_CSQ_IB1_STAT;
typedef union CP_CSQ_IB2_STAT                   regCP_CSQ_IB2_STAT;
typedef union CP_NON_PREFETCH_CNTRS             regCP_NON_PREFETCH_CNTRS;
typedef union CP_STQ_ST_STAT                    regCP_STQ_ST_STAT;
typedef union CP_MEQ_STAT                       regCP_MEQ_STAT;
typedef union CP_MIU_TAG_STAT                   regCP_MIU_TAG_STAT;
typedef union CP_CMD_INDEX                      regCP_CMD_INDEX;
typedef union CP_CMD_DATA                       regCP_CMD_DATA;
typedef union CP_ME_CNTL                        regCP_ME_CNTL;
typedef union CP_ME_STATUS                      regCP_ME_STATUS;
typedef union CP_ME_RAM_WADDR                   regCP_ME_RAM_WADDR;
typedef union CP_ME_RAM_RADDR                   regCP_ME_RAM_RADDR;
typedef union CP_ME_RAM_DATA                    regCP_ME_RAM_DATA;
typedef union CP_ME_RDADDR                      regCP_ME_RDADDR;
typedef union CP_DEBUG                          regCP_DEBUG;
typedef union SCRATCH_REG0                      regSCRATCH_REG0;
typedef union GUI_SCRATCH_REG0                  regGUI_SCRATCH_REG0;
typedef union SCRATCH_REG1                      regSCRATCH_REG1;
typedef union GUI_SCRATCH_REG1                  regGUI_SCRATCH_REG1;
typedef union SCRATCH_REG2                      regSCRATCH_REG2;
typedef union GUI_SCRATCH_REG2                  regGUI_SCRATCH_REG2;
typedef union SCRATCH_REG3                      regSCRATCH_REG3;
typedef union GUI_SCRATCH_REG3                  regGUI_SCRATCH_REG3;
typedef union SCRATCH_REG4                      regSCRATCH_REG4;
typedef union GUI_SCRATCH_REG4                  regGUI_SCRATCH_REG4;
typedef union SCRATCH_REG5                      regSCRATCH_REG5;
typedef union GUI_SCRATCH_REG5                  regGUI_SCRATCH_REG5;
typedef union SCRATCH_REG6                      regSCRATCH_REG6;
typedef union GUI_SCRATCH_REG6                  regGUI_SCRATCH_REG6;
typedef union SCRATCH_REG7                      regSCRATCH_REG7;
typedef union GUI_SCRATCH_REG7                  regGUI_SCRATCH_REG7;
typedef union SCRATCH_UMSK                      regSCRATCH_UMSK;
typedef union SCRATCH_ADDR                      regSCRATCH_ADDR;
typedef union CP_ME_VS_EVENT_SRC                regCP_ME_VS_EVENT_SRC;
typedef union CP_ME_VS_EVENT_ADDR               regCP_ME_VS_EVENT_ADDR;
typedef union CP_ME_VS_EVENT_DATA               regCP_ME_VS_EVENT_DATA;
typedef union CP_ME_VS_EVENT_ADDR_SWM           regCP_ME_VS_EVENT_ADDR_SWM;
typedef union CP_ME_VS_EVENT_DATA_SWM           regCP_ME_VS_EVENT_DATA_SWM;
typedef union CP_ME_PS_EVENT_SRC                regCP_ME_PS_EVENT_SRC;
typedef union CP_ME_PS_EVENT_ADDR               regCP_ME_PS_EVENT_ADDR;
typedef union CP_ME_PS_EVENT_DATA               regCP_ME_PS_EVENT_DATA;
typedef union CP_ME_PS_EVENT_ADDR_SWM           regCP_ME_PS_EVENT_ADDR_SWM;
typedef union CP_ME_PS_EVENT_DATA_SWM           regCP_ME_PS_EVENT_DATA_SWM;
typedef union CP_ME_CF_EVENT_SRC                regCP_ME_CF_EVENT_SRC;
typedef union CP_ME_CF_EVENT_ADDR               regCP_ME_CF_EVENT_ADDR;
typedef union CP_ME_CF_EVENT_DATA               regCP_ME_CF_EVENT_DATA;
typedef union CP_ME_NRT_ADDR                    regCP_ME_NRT_ADDR;
typedef union CP_ME_NRT_DATA                    regCP_ME_NRT_DATA;
typedef union CP_ME_VS_FETCH_DONE_SRC           regCP_ME_VS_FETCH_DONE_SRC;
typedef union CP_ME_VS_FETCH_DONE_ADDR          regCP_ME_VS_FETCH_DONE_ADDR;
typedef union CP_ME_VS_FETCH_DONE_DATA          regCP_ME_VS_FETCH_DONE_DATA;
typedef union CP_INT_CNTL                       regCP_INT_CNTL;
typedef union CP_INT_STATUS                     regCP_INT_STATUS;
typedef union CP_INT_ACK                        regCP_INT_ACK;
typedef union CP_PFP_UCODE_ADDR                 regCP_PFP_UCODE_ADDR;
typedef union CP_PFP_UCODE_DATA                 regCP_PFP_UCODE_DATA;
typedef union CP_PERFMON_CNTL                   regCP_PERFMON_CNTL;
typedef union CP_PERFCOUNTER_SELECT             regCP_PERFCOUNTER_SELECT;
typedef union CP_PERFCOUNTER_LO                 regCP_PERFCOUNTER_LO;
typedef union CP_PERFCOUNTER_HI                 regCP_PERFCOUNTER_HI;
typedef union CP_BIN_MASK_LO                    regCP_BIN_MASK_LO;
typedef union CP_BIN_MASK_HI                    regCP_BIN_MASK_HI;
typedef union CP_BIN_SELECT_LO                  regCP_BIN_SELECT_LO;
typedef union CP_BIN_SELECT_HI                  regCP_BIN_SELECT_HI;
typedef union CP_NV_FLAGS_0                     regCP_NV_FLAGS_0;
typedef union CP_NV_FLAGS_1                     regCP_NV_FLAGS_1;
typedef union CP_NV_FLAGS_2                     regCP_NV_FLAGS_2;
typedef union CP_NV_FLAGS_3                     regCP_NV_FLAGS_3;
typedef union CP_STATE_DEBUG_INDEX              regCP_STATE_DEBUG_INDEX;
typedef union CP_STATE_DEBUG_DATA               regCP_STATE_DEBUG_DATA;
typedef union CP_PROG_COUNTER                   regCP_PROG_COUNTER;
typedef union CP_STAT                           regCP_STAT;
typedef union BIOS_0_SCRATCH                    regBIOS_0_SCRATCH;
typedef union BIOS_1_SCRATCH                    regBIOS_1_SCRATCH;
typedef union BIOS_2_SCRATCH                    regBIOS_2_SCRATCH;
typedef union BIOS_3_SCRATCH                    regBIOS_3_SCRATCH;
typedef union BIOS_4_SCRATCH                    regBIOS_4_SCRATCH;
typedef union BIOS_5_SCRATCH                    regBIOS_5_SCRATCH;
typedef union BIOS_6_SCRATCH                    regBIOS_6_SCRATCH;
typedef union BIOS_7_SCRATCH                    regBIOS_7_SCRATCH;
typedef union BIOS_8_SCRATCH                    regBIOS_8_SCRATCH;
typedef union BIOS_9_SCRATCH                    regBIOS_9_SCRATCH;
typedef union BIOS_10_SCRATCH                   regBIOS_10_SCRATCH;
typedef union BIOS_11_SCRATCH                   regBIOS_11_SCRATCH;
typedef union BIOS_12_SCRATCH                   regBIOS_12_SCRATCH;
typedef union BIOS_13_SCRATCH                   regBIOS_13_SCRATCH;
typedef union BIOS_14_SCRATCH                   regBIOS_14_SCRATCH;
typedef union BIOS_15_SCRATCH                   regBIOS_15_SCRATCH;
typedef union COHER_SIZE_PM4                    regCOHER_SIZE_PM4;
typedef union COHER_BASE_PM4                    regCOHER_BASE_PM4;
typedef union COHER_STATUS_PM4                  regCOHER_STATUS_PM4;
typedef union COHER_SIZE_HOST                   regCOHER_SIZE_HOST;
typedef union COHER_BASE_HOST                   regCOHER_BASE_HOST;
typedef union COHER_STATUS_HOST                 regCOHER_STATUS_HOST;
typedef union COHER_DEST_BASE_0                 regCOHER_DEST_BASE_0;
typedef union COHER_DEST_BASE_1                 regCOHER_DEST_BASE_1;
typedef union COHER_DEST_BASE_2                 regCOHER_DEST_BASE_2;
typedef union COHER_DEST_BASE_3                 regCOHER_DEST_BASE_3;
typedef union COHER_DEST_BASE_4                 regCOHER_DEST_BASE_4;
typedef union COHER_DEST_BASE_5                 regCOHER_DEST_BASE_5;
typedef union COHER_DEST_BASE_6                 regCOHER_DEST_BASE_6;
typedef union COHER_DEST_BASE_7                 regCOHER_DEST_BASE_7;
typedef union RB_SURFACE_INFO                   regRB_SURFACE_INFO;
typedef union RB_COLOR_INFO                     regRB_COLOR_INFO;
typedef union RB_DEPTH_INFO                     regRB_DEPTH_INFO;
typedef union RB_STENCILREFMASK                 regRB_STENCILREFMASK;
typedef union RB_ALPHA_REF                      regRB_ALPHA_REF;
typedef union RB_COLOR_MASK                     regRB_COLOR_MASK;
typedef union RB_BLEND_RED                      regRB_BLEND_RED;
typedef union RB_BLEND_GREEN                    regRB_BLEND_GREEN;
typedef union RB_BLEND_BLUE                     regRB_BLEND_BLUE;
typedef union RB_BLEND_ALPHA                    regRB_BLEND_ALPHA;
typedef union RB_FOG_COLOR                      regRB_FOG_COLOR;
typedef union RB_STENCILREFMASK_BF              regRB_STENCILREFMASK_BF;
typedef union RB_DEPTHCONTROL                   regRB_DEPTHCONTROL;
typedef union RB_BLENDCONTROL                   regRB_BLENDCONTROL;
typedef union RB_COLORCONTROL                   regRB_COLORCONTROL;
typedef union RB_MODECONTROL                    regRB_MODECONTROL;
typedef union RB_COLOR_DEST_MASK                regRB_COLOR_DEST_MASK;
typedef union RB_COPY_CONTROL                   regRB_COPY_CONTROL;
typedef union RB_COPY_DEST_BASE                 regRB_COPY_DEST_BASE;
typedef union RB_COPY_DEST_PITCH                regRB_COPY_DEST_PITCH;
typedef union RB_COPY_DEST_INFO                 regRB_COPY_DEST_INFO;
typedef union RB_COPY_DEST_PIXEL_OFFSET         regRB_COPY_DEST_PIXEL_OFFSET;
typedef union RB_DEPTH_CLEAR                    regRB_DEPTH_CLEAR;
typedef union RB_SAMPLE_COUNT_CTL               regRB_SAMPLE_COUNT_CTL;
typedef union RB_SAMPLE_COUNT_ADDR              regRB_SAMPLE_COUNT_ADDR;
typedef union RB_BC_CONTROL                     regRB_BC_CONTROL;
typedef union RB_EDRAM_INFO                     regRB_EDRAM_INFO;
typedef union RB_CRC_RD_PORT                    regRB_CRC_RD_PORT;
typedef union RB_CRC_CONTROL                    regRB_CRC_CONTROL;
typedef union RB_CRC_MASK                       regRB_CRC_MASK;
typedef union RB_PERFCOUNTER0_SELECT            regRB_PERFCOUNTER0_SELECT;
typedef union RB_PERFCOUNTER0_LOW               regRB_PERFCOUNTER0_LOW;
typedef union RB_PERFCOUNTER0_HI                regRB_PERFCOUNTER0_HI;
typedef union RB_TOTAL_SAMPLES                  regRB_TOTAL_SAMPLES;
typedef union RB_ZPASS_SAMPLES                  regRB_ZPASS_SAMPLES;
typedef union RB_ZFAIL_SAMPLES                  regRB_ZFAIL_SAMPLES;
typedef union RB_SFAIL_SAMPLES                  regRB_SFAIL_SAMPLES;
typedef union RB_DEBUG_0                        regRB_DEBUG_0;
typedef union RB_DEBUG_1                        regRB_DEBUG_1;
typedef union RB_DEBUG_2                        regRB_DEBUG_2;
typedef union RB_DEBUG_3                        regRB_DEBUG_3;
typedef union RB_DEBUG_4                        regRB_DEBUG_4;
typedef union RB_FLAG_CONTROL                   regRB_FLAG_CONTROL;
typedef union RB_BC_SPARES                      regRB_BC_SPARES;
typedef union BC_DUMMY_CRAYRB_ENUMS             regBC_DUMMY_CRAYRB_ENUMS;
typedef union BC_DUMMY_CRAYRB_MOREENUMS         regBC_DUMMY_CRAYRB_MOREENUMS;
#endif
